% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{e_show_loading}
\alias{e_show_loading}
\alias{e_hide_loading}
\title{Loading}
\usage{
e_show_loading(
  e,
  hide_overlay = TRUE,
  text = "loading",
  color = "#c23531",
  text_color = "#000",
  mask_color = "rgba(255, 255, 255, 0.8)",
  zlevel = 0
)

e_hide_loading(e)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{hide_overlay}{Hides the white overlay that appears in shiny when a plot is recalculating.}

\item{text}{Text to display.}

\item{color}{Color of spinner.}

\item{text_color}{Color of text.}

\item{mask_color}{Color of mask.}

\item{zlevel}{Z level.}
}
\description{
Show or hide loading.
}
\details{
This only applies to Shiny.
}
\examples{
\dontrun{

# no redraw
# no loading
library(shiny)
ui <- fluidPage(
  fluidRow(
    column(12, actionButton("update", "Update"))
  ),
  fluidRow(
    column(12, echarts4rOutput("plot"))
  )
)

server <- function(input, output) {
  data <- eventReactive(input$update, {
    data.frame(
      x = 1:10,
      y = rnorm(10)
    )
  })

  output$plot <- renderEcharts4r({
    data() |>
      e_charts(x) |>
      e_bar(y)
  })
}

if (interactive()) {
  shinyApp(ui, server)
}

# add loading
server <- function(input, output) {
  data <- eventReactive(input$update, {
    Sys.sleep(1) # sleep one second to show loading
    data.frame(
      x = 1:10,
      y = rnorm(10)
    )
  })

  output$plot <- renderEcharts4r({
    data() |>
      e_charts(x) |>
      e_bar(y) |>
      e_show_loading()
  })
}

if (interactive()) {
  shinyApp(ui, server)
}
}

}
