# Generated by 02-duckplyr_df-methods.R
#' @export
rows_delete.duckplyr_df <- function(x, y, by = NULL, ..., unmatched = c("error", "ignore"), copy = FALSE, in_place = FALSE) {
  # Our implementation
  duckplyr_error <- rel_try(NULL,
    "No relational implementation for {.code rows_delete()}" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(x, duckplyr_error)

  rows_delete <- dplyr$rows_delete.data.frame
  out <- rows_delete(x, y, by, ..., unmatched = unmatched, copy = copy, in_place = in_place)
  return(out)

  # dplyr implementation
  check_dots_empty()
  rows_df_in_place(in_place)

  y <- auto_copy(x, y, copy = copy)

  by <- rows_check_by(by, y)

  rows_check_contains_by(x, by, "x")
  rows_check_contains_by(y, by, "y")

  x_key <- dplyr_col_select(x, by)
  y_key <- dplyr_col_select(y, by)

  args <- vec_cast_common(x = x_key, y = y_key)
  x_key <- args$x
  y_key <- args$y

  keep <- rows_check_y_unmatched(x_key, y_key, unmatched)

  if (!is.null(keep)) {
    y_key <- dplyr_row_slice(y_key, keep)
  }

  extra <- setdiff(names(y), names(y_key))
  if (!is_empty(extra)) {
    message <- glue(
      "Ignoring extra `y` columns: ",
      commas(tick_if_needed(extra))
    )
    inform(
      message,
      class = c("dplyr_message_delete_extra_cols", "dplyr_message")
    )
  }

  loc <- vec_match(x_key, y_key)
  unmatched <- is.na(loc)

  x_loc <- which(unmatched)

  dplyr_row_slice(x, x_loc)
}

duckplyr_rows_delete <- function(x, y, ...) {
  try_fetch(
    {
      x <- as_duckplyr_df_impl(x)
      y <- as_duckplyr_df_impl(y)
    },
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- rows_delete(x, y, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
