% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_regression.R
\name{logreg}
\alias{logreg}
\title{Logistic Regression Summary Table}
\arguments{
\item{data}{A data frame containing the outcome and predictor variables.}

\item{outcome}{A character string (factor)specifying the binary outcome variable.}

\item{predictors}{A character vector (factor) of predictor variables to include in the regression.}
}
\value{
A flextable displaying univariate and multivariate odds ratios (95\% CI)
and p-values for each predictor. Reference levels for categorical variables are labeled "Reference".
}
\description{
Performs logistic regression for a binary outcome and a set of predictor variables.
Computes both univariate and multivariate odds ratios (ORs) with 95\% confidence intervals
and p-values. Categorical variables automatically include a reference level in the output.
Results are returned as a formatted flextable.
}
\examples{
logreg(data=medical_data(), outcome="case" ,
   predictors= c("age" ,  "parity" ,    "induced" ))
}
