% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_geometry.R
\name{interval_geometry}
\alias{interval_geometry}
\alias{int_width}
\alias{int_radius}
\alias{int_center}
\alias{int_overlap}
\alias{int_containment}
\alias{int_midrange}
\title{Geometric Properties of Interval Data}
\usage{
int_width(x, var_name, ...)

int_radius(x, var_name, ...)

int_center(x, var_name, ...)

int_overlap(x, var_name1, var_name2, ...)

int_containment(x, var_name1, var_name2, ...)

int_midrange(x, var_name, ...)
}
\arguments{
\item{x}{interval-valued data with symbolic_tbl class.}

\item{var_name}{the variable name or the column location (multiple variables are allowed).}

\item{...}{additional parameters}

\item{var_name1}{the first variable name or column location.}

\item{var_name2}{the second variable name or column location.}
}
\value{
A numeric matrix or value
}
\description{
Functions to compute geometric characteristics of interval-valued data.
}
\details{
These functions compute basic geometric properties:
\itemize{
  \item \code{int_width}: Width of each interval (upper - lower)
  \item \code{int_radius}: Radius of each interval (width / 2)
  \item \code{int_center}: Center point of each interval ((lower + upper) / 2)
  \item \code{int_overlap}: Overlap measure between two interval variables
  \item \code{int_containment}: Check if one interval contains another
}
}
\examples{
data(mushroom.int)

# Calculate interval widths
int_width(mushroom.int, var_name = "Pileus.Cap.Width")
int_width(mushroom.int, var_name = 2:3)

# Calculate interval radius
int_radius(mushroom.int, var_name = c("Stipe.Length", "Stipe.Thickness"))

# Get interval centers
int_center(mushroom.int, var_name = 2:4)

# Measure overlap between two variables
int_overlap(mushroom.int, "Pileus.Cap.Width", "Stipe.Length")
}
\seealso{
int_width int_radius int_center int_overlap
}
\author{
Han-Ming Wu
}
