% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{ensure_model}
\alias{ensure_model}
\title{Internal: ensure a fitted model exists for an instance and panel}
\usage{
ensure_model(
  inst_key,
  token,
  data,
  methods,
  plan,
  fit_child_map,
  pred_child_map,
  K,
  fold_idx,
  model_cache
)
}
\arguments{
\item{inst_key}{Instance key in \code{plan$instances}.}

\item{token}{An evaluation or training token (see
\code{\link{make_eval_token}} and \code{\link{make_train_token}}).}

\item{data}{Training data (matrix or data frame).}

\item{methods}{Methods list used to build \code{plan}.}

\item{plan}{Cross-fitting plan as returned by
\code{build_instances()}.}

\item{fit_child_map}{Child map for \code{fit()} dependencies (from
\code{\link{build_child_maps}}).}

\item{pred_child_map}{Child map for \code{predict()} dependencies.}

\item{K}{Number of folds.}

\item{fold_idx}{List mapping folds \code{1:K} to row indices.}

\item{model_cache}{Environment used to store fitted models.}
}
\value{
A fitted model object for the given instance and token.
}
\description{
For a given instance and token, this function either retrieves a
cached fitted model (based on its model signature) or fits a new one
using the appropriate training folds, then optionally caches it.
}
\details{
Child nuisances are recursively predicted on the training window and
passed as additional arguments into the instance's \code{fit()}
function.

Structural failures are recorded in \code{plan$fail_env} so that
methods relying on the same structural model can be skipped for the
current repetition.
}
\keyword{internal}
