testthat::test_that("covfefefy produces proper results",{
  testthat::expect_equal(covfefy("coverage"),"covfefe")
  testthat::expect_equal(covfefy("example"),"exxaxa")
  testthat::expect_equal(covfefy("programming"),"progkaka")
  testthat::expect_equal(covfefy("president"),"preszizi")
})

testthat::test_that("covfefySentence handles sentences with commas", {
  result <- covfefySentence("Despite the constant negative press coverage, we are going to Make America Great Again")
  testthat::expect_equal(result, "Despite the constant negative press covfefe")
})

testthat::test_that("covfefySentence returns short sentences unchanged", {
  result <- covfefySentence("Short sentence here")
  testthat::expect_equal(result, "Short sentence here")
})

testthat::test_that("covfefySentence handles sentences without commas", {
  # Sentences >= 10 words without comma get word at 75% position covfefied
  result <- covfefySentence("We will bring back our jobs and our borders and our wealth")
  testthat::expect_true(nchar(result) > 0)
  testthat::expect_true(grepl("bring|back|jobs|borders|wealth", result))
})

testthat::test_that("covfefySpeech processes text and writes to tempdir", {
  outfile <- file.path(tempdir(), "test_speech_output.txt")
  result <- covfefySpeech(out = outfile)

  # Function returns the processed text
  testthat::expect_true(nchar(result) > 0)
  testthat::expect_true(grepl("covfefe|fefe|pepe|titi", result, ignore.case = TRUE))

  # File was created
  testthat::expect_true(file.exists(outfile))

  # Clean up
  unlink(outfile)
})

testthat::test_that("covfefySpeech does not write to working directory by default", {
  # Capture files before
  before <- list.files(pattern = "\\.txt$")

  result <- covfefySpeech()

  # No new txt files in working directory
  after <- list.files(pattern = "\\.txt$")
  testthat::expect_equal(before, after)
})
