% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_attributes.R, R/detect_scales.R
\name{detect_scales}
\alias{detect_scales}
\title{Detect item scales}
\usage{
detect_scales(data, quiet = FALSE)

detect_scales(data, quiet = FALSE)
}
\arguments{
\item{data}{the data frame}

\item{quiet}{defaults to false. Suppresses messages about found items.}
}
\description{
Did you create aggregates of items like this
\code{scale <- scale_1 + scale_2R + scale_3R}?
If you run this function on a dataset, it will detect these
relationships and set the appropriate attributes. Once they are set,
the codebook package can perform reliability computations for you.

Did you create aggregates of items like this
\code{scale <- scale_1 + scale_2R + scale_3R}?
If you run this function on a dataset, it will detect these
relationships and set the appropriate attributes. Once they are set,
the codebook package can perform reliability computations for you.
}
\examples{
bfi <- data.frame(matrix(data = rnorm(300), ncol = 3))
names(bfi) <- c("bfi_e1", "bfi_e2R", "bfi_e3")
bfi$bfi_e <- rowMeans(bfi[, c("bfi_e1", "bfi_e2R", "bfi_e3")])
bfi <- detect_scales(bfi)
bfi$bfi_e
bfi <- data.frame(matrix(data = rnorm(300), ncol = 3))
names(bfi) <- c("bfi_e1", "bfi_e2R", "bfi_e3")
bfi$bfi_e <- rowMeans(bfi[, c("bfi_e1", "bfi_e2R", "bfi_e3")])
bfi <- detect_scales(bfi)
bfi$bfi_e
}
