\name{vacs_1_0_index}
\alias{vacs_1_0_index}
\title{
Veterans Aging Cohort Study (VACS) 1.0 Index
}
\description{
Calculates the VACS Index 1.0 score to estimate the risk of all-cause mortality in patients with HIV. The score integrates age, HIV-specific biomarkers (CD4, Viral Load), and general organ system injury markers (Hemoglobin, FIB-4 for liver fibrosis, eGFR for renal function, and Hepatitis C status).
}
\usage{
vacs_1_0_index(age, cd4_count, hiv_rna, hemoglobin, platelets, ast, alt,
               creatinine, hepatitis_c_positive, sex = "male", race = "other")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{cd4_count}{
Numeric. CD4 T-cell count (cells/mm^3).
}
  \item{hiv_rna}{
Numeric. HIV-1 RNA viral load (copies/mL).
}
  \item{hemoglobin}{
Numeric. Hemoglobin level (g/dL).
}
  \item{platelets}{
Numeric. Platelet count (x10^3/uL or x10^9/L).
}
  \item{ast}{
Numeric. Aspartate Aminotransferase (AST) level (U/L).
}
  \item{alt}{
Numeric. Alanine Aminotransferase (ALT) level (U/L).
}
  \item{creatinine}{
Numeric. Serum Creatinine level (mg/dL).
}
  \item{hepatitis_c_positive}{
Numeric (0 or 1). Hepatitis C virus (HCV) status (1 = Positive).
}
  \item{sex}{
String. Patient sex ("male" or "female"). Used for eGFR calculation.
}
  \item{race}{
String. Patient race ("black", "african american", "other"). Used for eGFR calculation (MDRD).
}
}
\value{
A list containing:
\item{VACS_Index_Score}{The calculated total score (Range 0 to ~164).}
\item{Calculated_Values}{Derived FIB-4 and eGFR values used in the score.}
}
\references{
Justice AC, Modur SP, Tate JP, et al. Predictive accuracy of the Veterans Aging Cohort Study (VACS) Index for mortality with HIV infection: a North American cross cohort analysis. J Acquir Immune Defic Syndr. 2013;62(2):149-163. doi:10.1097/QAI.0b013e31827df36c
}
\examples{

# Example 1: Low Risk
# 40yo, CD4 600, VL <500, Hgb 15, Plt 250, AST 20, ALT 20, Cr 0.9, HCV-
vacs_1_0_index(40, 600, 400, 15, 250, 20, 20, 0.9, 0)

# Example 2: High Risk
# 55yo (+12), CD4 150 (+10), VL 50k (+7), Hgb 11 (+22), FIB-4 >3.25 (+25), eGFR <30 (+26), HCV+ (+5)
# Approx calculation: 55y, CD4 150, VL 50000, Hgb 11, Plt 100, AST 100, ALT 40, Cr 3.0, HCV+
vacs_1_0_index(55, 150, 50000, 11, 100, 100, 40, 3.0, 1, "male", "black")
}
