\name{khorana_vte_score}
\alias{khorana_vte_score}
\title{
Khorana Risk Score for Venous Thromboembolism in Cancer Patients
}
\description{
Calculates the Khorana Score to predict the risk of Venous Thromboembolism (VTE) in ambulatory cancer patients initiating chemotherapy. The score stratifies patients into Low, Intermediate, or High risk categories based on cancer site, platelet count, hemoglobin, leukocyte count, and BMI.
}
\usage{
khorana_vte_score(cancer_site_risk, platelet_count, hemoglobin, wbc_count, bmi)
}
\arguments{
  \item{cancer_site_risk}{
String. Risk category of the primary tumor site.
"very_high": Stomach, Pancreas (+2 pts).
"high": Lung, Lymphoma, Gynecologic, Bladder, Testicular (+1 pt).
"low": Other sites (0 pts).
}
  \item{platelet_count}{
Numeric. Pre-chemotherapy platelet count in x10^9/L. (>= 350 adds 1 point).
}
  \item{hemoglobin}{
Numeric. Hemoglobin level in g/dL. (< 10 g/dL or use of ESAs adds 1 point).
}
  \item{wbc_count}{
Numeric. Pre-chemotherapy leukocyte count in x10^9/L. (> 11 adds 1 point).
}
  \item{bmi}{
Numeric. Body Mass Index in kg/m^2. (>= 35 adds 1 point).
}
}
\value{
A list containing:
\item{Khorana_Score}{The calculated risk score (Range 0-6).}
\item{Risk_Classification}{Risk group classification (Low, Intermediate, High).}
\item{Estimated_VTE_Risk}{Estimated percentage risk of symptomatic VTE.}
}
\references{
Khorana AA, Kuderer NM, Culakova E, Lyman GH, Francis CW. Development and validation of a predictive model for chemotherapy-associated thrombosis. Blood. 2008;111(10):4902-4907. doi:10.1182/blood-2007-10-116327
}
\examples{

# Example 1: High Risk (Pancreas)
# Pancreas (+2), Plt 400 (+1), BMI 28 (0)
# Score = 3
khorana_vte_score("very_high", 400, 12, 8, 28)

# Example 2: Low Risk (Breast)
# Breast (Low risk site 0), Normal labs, Normal BMI
# Score = 0
khorana_vte_score("low", 250, 13, 6, 24)
}
