\name{hamilton_anxiety_scale}
\alias{hamilton_anxiety_scale}
\title{
Hamilton Anxiety Rating Scale (HAM-A)
}
\description{
Calculates the HAM-A score, a 14-item clinician-administered rating scale used to assess the severity of anxiety symptoms. Each item is scored on a scale of 0 (Not present) to 4 (Very severe). The total score (0-56) indicates the overall level of anxiety.
}
\usage{
hamilton_anxiety_scale(anxious_mood, tension, fears, insomnia, intellectual,
                       depressed_mood, somatic_muscular, somatic_sensory,
                       cardiovascular, respiratory, gastrointestinal,
                       genitourinary, autonomic, behavior_at_interview)
}
\arguments{
  \item{anxious_mood}{Numeric (0-4). Worries, anticipation of the worst, fearful anticipation, irritability.}
  \item{tension}{Numeric (0-4). Feelings of tension, fatigability, startle response, moved to tears easily, trembling, feelings of restlessness, inability to relax.}
  \item{fears}{Numeric (0-4). Of dark, of strangers, of being left alone, of animals, of traffic, of crowds.}
  \item{insomnia}{Numeric (0-4). Difficulty in falling asleep, broken sleep, unsatisfying sleep and fatigue on waking, dreams, nightmares, night terrors.}
  \item{intellectual}{Numeric (0-4). Difficulty in concentration, poor memory.}
  \item{depressed_mood}{Numeric (0-4). Loss of interest, lack of pleasure in hobbies, depression, early waking, diurnal swing.}
  \item{somatic_muscular}{Numeric (0-4). Pains and aches, twitching, stiffness, myoclonic jerks, grinding of teeth, unsteady voice, increased muscular tone.}
  \item{somatic_sensory}{Numeric (0-4). Tinnitus, blurring of vision, hot and cold flushes, feelings of weakness, picking sensation.}
  \item{cardiovascular}{Numeric (0-4). Tachycardia, palpitations, pain in chest, throbbing of vessels, fainting feelings, missing beat.}
  \item{respiratory}{Numeric (0-4). Pressure or constriction in chest, choking feelings, sighing, dyspnea.}
  \item{gastrointestinal}{Numeric (0-4). Difficulty in swallowing, wind abdominal pain, burning sensations, abdominal fullness, nausea, vomiting, borborygmi, looseness of bowels, loss of weight, constipation.}
  \item{genitourinary}{Numeric (0-4). Frequency of micturition, urgency of micturition, amenorrhea, menorrhagia, development of frigidity, premature ejaculation, loss of libido, impotence.}
  \item{autonomic}{Numeric (0-4). Dry mouth, flushing, pallor, tendency to sweat, giddiness, tension headache, raising of hair.}
  \item{behavior_at_interview}{Numeric (0-4). Fidgeting, restlessness or pacing, tremor of hands, furrowed brow, strained face, sighing or rapid respiration, facial pallor, swallowing, etc.}
}
\details{
\strong{Scoring Key:}
0 = Not present
1 = Mild
2 = Moderate
3 = Severe
4 = Very severe
}
\value{
A list containing:
\item{HAM_A_Score}{The calculated total score (Range 0-56).}
\item{Severity_Category}{Interpretation (Mild <=17, Mild-Moderate 18-24, Mod-Severe 25-30, Severe >30).}
}
\references{
Hamilton M. The assessment of anxiety states by rating. Br J Med Psychol. 1959;32(1):50-55. doi:10.1111/j.2044-8341.1959.tb00467.x
}
\examples{

# Example 1: Severe Anxiety
# All items scored 3 (Severe)
hamilton_anxiety_scale(3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3)

# Example 2: Mild Anxiety
# Most items 0 or 1
hamilton_anxiety_scale(1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0)
}
