\name{fuhrman_nuclear_grade}
\alias{fuhrman_nuclear_grade}
\title{
Fuhrman Nuclear Grade for Clear Cell Renal Carcinoma
}
\description{
Determines the Fuhrman Nuclear Grade for renal cell carcinoma (RCC). This histologic grading system is a powerful predictor of metastasis and survival in clear cell RCC. It evaluates nuclear size, irregularity, and nucleolar prominence.
}
\usage{
fuhrman_nuclear_grade(nuclear_diameter_um, nuclear_shape_irregular,
                      nucleoli_visible, magnification_needed)
}
\arguments{
  \item{nuclear_diameter_um}{
Numeric. Approximate diameter of the nuclei in micrometers.
~10 um: Grade 1.
~15 um: Grade 2 or 3.
>20 um: Grade 4.
}
  \item{nuclear_shape_irregular}{
Numeric (0 or 1). Are the nuclei irregular in outline? (1 = Yes).
}
  \item{nucleoli_visible}{
Numeric (0 or 1). Are nucleoli visible? (1 = Yes).
}
  \item{magnification_needed}{
String. Magnification required to visualize nucleoli clearly.
"400x": High power (Grade 2).
"100x": Low power (Grade 3).
"10x": Low power (Grade 3).
}
}
\value{
A list containing:
\item{Fuhrman_Grade}{The calculated grade (1, 2, 3, or 4).}
\item{Histologic_Description}{Description of the nuclear features for the grade.}
\item{Prognosis}{General prognostic category.}
\item{Est_5_Year_Survival}{Estimated 5-year survival rate based on grade.}
}
\references{
Fuhrman SA, Lasky LC, Limas C. Prognostic significance of morphologic parameters in renal cell carcinoma. Am J Surg Pathol. 1982;6(7):655-663.
}
\examples{

# Example 1: Grade 2
# 15um, irregular, nucleoli visible at 400x
fuhrman_nuclear_grade(15, 1, 1, "400x")

# Example 2: Grade 4
# 25um, bizarre shape, prominent nucleoli
fuhrman_nuclear_grade(25, 1, 1, "10x")
}
