% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disco.R
\name{disco}
\alias{disco}
\title{Perform Causal Discovery}
\usage{
disco(data, method, knowledge = NULL)
}
\arguments{
\item{data}{A data frame.}

\item{method}{A \code{disco_method} object representing a causal discovery
algorithm. Available methods are
\itemize{
\item \code{\link[=boss]{boss()}} - BOSS algorithm,
\item \code{\link[=boss_fci]{boss_fci()}} - BOSS-FCI algorithm,
\item \code{\link[=fci]{fci()}} - FCI algorithm,
\item \code{\link[=gfci]{gfci()}} - GFCI algorithm,
\item \code{\link[=ges]{ges()}} - GES algorithm,
\item \code{\link[=grasp]{grasp()}} - GRaSP algorithm,
\item \code{\link[=grasp_fci]{grasp_fci()}} - GRaSP-FCI algorithm,
\item \code{\link[=gs]{gs()}} - GS algorithm,
\item \code{\link[=iamb]{iamb()}}, \code{\link[=iamb_fdr]{iamb_fdr()}}, \code{\link[=fast_iamb]{fast_iamb()}}, \code{\link[=inter_iamb]{inter_iamb()}} - IAMB algorithms,
\item \code{\link[=pc]{pc()}} - PC algorithm,
\item \code{\link[=sp_fci]{sp_fci()}} - SP-FCI algorithm,
\item \code{\link[=tfci]{tfci()}} - TFCI algorithm,
\item \code{\link[=tges]{tges()}} - TGES algorithm,
\item \code{\link[=tpc]{tpc()}} - TPC algorithm.
}}

\item{knowledge}{A \code{Knowledge} object to be incorporated into the causal discovery algorithm.
If \code{NULL} (default), the causal discovery algorithm is run without background knowledge. See \code{\link[=knowledge]{knowledge()}}
for how to create a \code{Knowledge} object.}
}
\value{
A \code{Disco} object (a list) containing the following components:
\itemize{
\item \code{knowledge} A \code{Knowledge} object with the background knowledge
used in the causal discovery algorithm.
\item \code{caugi} A \link[caugi:caugi]{caugi::caugi} object representing the learned causal graph from the causal discovery algorithm.
}
}
\description{
Apply a causal discovery method to a data frame to infer causal relationships on observational data.
Supports multiple algorithms and optionally incorporates prior knowledge.
}
\details{
For specific details on the supported algorithms, scores, tests, and parameters for each engine, see:
\itemize{
\item \link{BnlearnSearch} for \pkg{bnlearn},
\item \link{CausalDiscoSearch} for \pkg{causalDisco},
\item \link{PcalgSearch} for \pkg{pcalg},
\item \link{TetradSearch} for \pkg{Tetrad}.
}
}
\examples{
data(tpc_example)

# use pc with engine bnlearn and test fisher_z
my_pc <- pc(engine = "bnlearn", test = "fisher_z", alpha = 0.01)
pc_bnlearn <- disco(data = tpc_example, method = my_pc)
plot(pc_bnlearn)

# define tiered background knowledge
kn <- knowledge(
  tpc_example,
  tier(
    child ~ starts_with("child"),
    youth ~ starts_with("youth"),
    old ~ starts_with("old")
  )
)

# use gs with engine bnlearn and test cor and tiered background knowledge
my_pc_tiered <- pc(engine = "bnlearn", test = "cor", alpha = 0.01)
pc_tiered_bnlearn <- disco(
  data = tpc_example,
  method = my_pc_tiered,
  knowledge = kn
)
plot(pc_tiered_bnlearn)
}
