% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shash.R
\name{shash}
\alias{shash}
\alias{dshash}
\alias{pshash}
\alias{qshash}
\alias{rshash}
\title{Sinh-Arcsinh (shash) Distribution}
\usage{
dshash(x, mu = 0, sigma = 1, epsilon = 0, delta = 1, log = FALSE)

pshash(
  q,
  mu = 0,
  sigma = 1,
  epsilon = 0,
  delta = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

qshash(
  p,
  mu = 0,
  sigma = 1,
  epsilon = 0,
  delta = 1,
  lower.tail = TRUE,
  log.p = FALSE
)

rshash(n, mu = 0, sigma = 1, epsilon = 0, delta = 1)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{location parameter (default: 0)}

\item{sigma}{scale parameter (must be > 0, default: 1)}

\item{epsilon}{skewness parameter (default: 0, symmetric distribution)}

\item{delta}{tail weight parameter (must be > 0, default: 1 for normal-like tails)}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p)}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x]
otherwise, P[X > x]}

\item{p}{vector of probabilities}

\item{n}{number of observations. If \code{length(n) > 1}, the length is
taken to be the number required.}
}
\value{
\code{dshash} gives the density, \code{pshash} gives the distribution
function, \code{qshash} gives the quantile function, and \code{rshash}
generates random deviates.

The length of the result is determined by \code{n} for \code{rshash}, and
is the maximum of the lengths of the numerical arguments for the other functions.
}
\description{
Density, distribution function, quantile function and random generation
for the Sinh-Arcsinh distribution with location parameter \code{mu},
scale parameter \code{sigma}, skewness parameter \code{epsilon}, and
tail weight parameter \code{delta}.
}
\details{
The Sinh-Arcsinh distribution (Jones & Pewsey, 2009) is defined by the transformation:
\deqn{X = \mu + \sigma \cdot \sinh\left(\frac{\text{asinh}(Z) - \epsilon}{\delta}\right)}
where \eqn{Z \sim N(0,1)} is a standard normal variable.

The four parameters control:
\itemize{
  \item \code{mu}: Location (similar to mean)
  \item \code{sigma}: Scale (similar to standard deviation)
  \item \code{epsilon}: Skewness (\code{epsilon = 0} gives symmetry)
  \item \code{delta}: Tail weight (\code{delta = 1} gives normal-like tails,
        \code{delta > 1} gives heavier tails, \code{delta < 1} gives lighter tails)
}
}
\examples{
# Generate random samples
x <- rshash(1000, mu = 0, sigma = 1, epsilon = 0.5, delta = 1.2)

# Density
plot(density(x))
curve(dshash(x, mu = 0, sigma = 1, epsilon = 0.5, delta = 1.2),
      add = TRUE, col = "red")

# Cumulative probability
pshash(0, mu = 0, sigma = 1, epsilon = 0.5, delta = 1.2)

# Quantiles
qshash(c(0.025, 0.5, 0.975), mu = 0, sigma = 1, epsilon = 0.5, delta = 1.2)

# Compare with normal distribution (epsilon = 0, delta = 1)
par(mfrow = c(2, 2))
x_vals <- seq(-4, 4, length.out = 200)
plot(x_vals, dshash(x_vals), type = "l", main = "Symmetric (like normal)")
plot(x_vals, dshash(x_vals, epsilon = 1), type = "l", main = "Right skewed")
plot(x_vals, dshash(x_vals, delta = 2), type = "l", main = "Heavy tails")
plot(x_vals, dshash(x_vals, delta = 0.5), type = "l", main = "Light tails")

}
\references{
Jones, M. C., & Pewsey, A. (2009). Sinh-arcsinh distributions.
\emph{Biometrika}, 96(4), 761-780. \doi{10.1093/biomet/asp053}
}
\seealso{
\link[stats]{Normal} for the normal distribution.
}
