% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranger.R
\name{axe-ranger}
\alias{axe-ranger}
\alias{axe_call.ranger}
\alias{axe_fitted.ranger}
\title{Axing an ranger.}
\usage{
\method{axe_call}{ranger}(x, verbose = FALSE, ...)

\method{axe_fitted}{ranger}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed ranger object.
}
\description{
ranger objects are created from the \pkg{ranger} package, which is
used as a means to quickly train random forests. The package supports
ensembles of classification, regression, survival and probability
prediction trees. Given the reliance of post processing functions on
the model object, like \code{importance_pvalues} and \code{treeInfo},
on the first class listed, the \code{butcher_ranger} class is not
appended.
}
\examples{
\dontshow{if (rlang::is_installed(c("parsnip", "rsample", "ranger"))) withAutoprint(\{ # examplesIf}
# Load libraries
library(parsnip)
library(rsample)
library(ranger)

# Load data
set.seed(1234)
split <- initial_split(iris, prop = 9/10)
iris_train <- training(split)

# Create model and fit
ranger_fit <- rand_forest(mode = "classification",
                          mtry = 2,
                          trees = 20,
                          min_n = 3) |>
  set_engine("ranger") |>
  fit(Species ~ ., data = iris_train)

out <- butcher(ranger_fit, verbose = TRUE)

# Another ranger object
wrapped_ranger <- function() {
  n <- 100
  p <- 400
  dat <- data.frame(y = factor(rbinom(n, 1, .5)), replicate(p, runif(n)))
  fit <- ranger(y ~ ., dat, importance = "impurity_corrected")
  return(fit)
}

cleaned_ranger <- axe_fitted(wrapped_ranger(), verbose = TRUE)
\dontshow{\}) # examplesIf}
}
