% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_call.R
\name{bunddev_call}
\alias{bunddev_call}
\title{Call an API operation}
\usage{
bunddev_call(
  api,
  operation_id = NULL,
  params = list(),
  path = NULL,
  method = NULL,
  parse = c("json", "text", "raw", "xml"),
  base_url = NULL,
  body = NULL,
  body_type = c("json", "form"),
  headers = NULL,
  safe = TRUE,
  refresh = FALSE
)
}
\arguments{
\item{api}{Registry id.}

\item{operation_id}{OpenAPI operationId (use this OR path+method).}

\item{params}{List of query parameters.}

\item{path}{API path (use with method instead of operation_id).}

\item{method}{HTTP method (use with path instead of operation_id).}

\item{parse}{Response parsing mode.}

\item{base_url}{Optional base URL override.}

\item{body}{Optional request body (for POST/PUT requests).}

\item{body_type}{Body encoding type ("json" or "form").}

\item{headers}{Optional named list of custom HTTP headers.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached GET responses.}
}
\value{
Parsed response.
}
\description{
Call an API operation
}
\details{
This is the low-level OpenAPI caller. It supports two modes:
\itemize{
\item Use \code{operation_id} to lookup endpoints by their OpenAPI operationId
\item Use \code{path} + \code{method} for APIs without operationIds
}

The function fills path parameters from \code{params}, applies auth (if
configured), and optionally caches GET responses when \code{safe = TRUE}.

Use \code{\link[=bunddev_parameters]{bunddev_parameters()}} and \code{\link[=bunddev_parameter_values]{bunddev_parameter_values()}} to discover valid
parameters before calling.
}
\examples{
\dontrun{
# Retrieve Autobahn road ids (raw response)
bunddev_call("autobahn", "list-autobahnen")
}

}
\seealso{
\code{\link[=bunddev_call_tidy]{bunddev_call_tidy()}} for adapter-specific tidy outputs, and
\code{\link[=bunddev_auth_set]{bunddev_auth_set()}} to configure API keys.
}
