% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libraries.R
\name{wait_for_lib_installs}
\alias{wait_for_lib_installs}
\title{Wait for Libraries to Install on Databricks Cluster}
\usage{
wait_for_lib_installs(
  cluster_id,
  polling_interval = 5,
  allow_failures = FALSE,
  host = db_host(),
  token = db_token()
)
}
\arguments{
\item{cluster_id}{Unique identifier of a Databricks cluster.}

\item{polling_interval}{Number of seconds to wait between status checks}

\item{allow_failures}{If \code{FALSE} (default) will error if any libraries status
is \code{FAILED}. When \code{TRUE} any \code{FAILED} installs will be presented as a
warning.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}
}
\description{
Wait for Libraries to Install on Databricks Cluster
}
\details{
Library installs on Databricks clusters are asynchronous, this function
allows you to repeatedly check installation status of each library.

Can be used to block any scripts until required dependencies are installed.
}
\seealso{
\code{\link[=db_libs_cluster_status]{db_libs_cluster_status()}}
}
