% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sass.R
\name{brand_sass_color_palette}
\alias{brand_sass_color_palette}
\title{Generate Sass variables and CSS custom properties for brand color palette}
\usage{
brand_sass_color_palette(brand)
}
\arguments{
\item{brand}{A list or string of YAML representing the brand, or a path to a
brand.yml file.}
}
\value{
A list with two components:
\itemize{
\item \code{defaults}: Sass variable definitions with \code{!default} flag
\item \code{rules}: CSS rules that define custom properties in \verb{:root}
}
}
\description{
Converts color palette entries from a brand object to Sass variables with
\verb{brand-} prefix and CSS custom properties with \verb{--brand-} prefix.
}
\examples{
brand <- list(
  color = list(
    palette = list(
      primary = "#007bff",
      secondary = "#6c757d"
    )
  )
)

brand_sass_color_palette(brand)

}
\seealso{
Other brand.yml Sass helpers: 
\code{\link{brand_sass_color}()},
\code{\link{brand_sass_defaults_bootstrap}()},
\code{\link{brand_sass_fonts}()},
\code{\link{brand_sass_typography}()}
}
\concept{brand.yml Sass helpers}
