% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament_inspection.R
\name{matches}
\alias{matches}
\alias{matches.tournament}
\title{Inspect tournament matches}
\usage{
matches(x, stage = NULL, status = "pending")

\method{matches}{tournament}(x, stage = NULL, status = "pending")
}
\arguments{
\item{x}{A \code{tournament} object.}

\item{stage}{Optional stage identifier.}

\item{status}{One of \code{"pending"}, \code{"complete"}, or \code{"all"}.}
}
\value{
Data frame of matches.
}
\description{
Inspect tournament matches
}
\examples{
trn <- tournament(c("A", "B", "C", "D")) |>
  round_robin("groups")

# Get pending matches
matches(trn, "groups")

# Get all matches across stages
matches(trn, status = "all")
}
