% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_ModelingOptions.R
\name{bm_ModelingOptions}
\alias{bm_ModelingOptions}
\title{Configure the modeling options for each selected model}
\usage{
bm_ModelingOptions(
  data.type = "binary",
  models,
  strategy,
  user.val = NULL,
  user.base = "bigboss",
  bm.format = NULL,
  calib.lines = NULL
)
}
\arguments{
\item{data.type}{a \code{character} corresponding to the data type to be used, must be either 
\code{binary}, \code{count}, \code{relative}, \code{abundance}, \code{multiclass}, \code{ordinal}}

\item{models}{a \code{vector} containing model names to be computed, must be among 
\code{ANN}, \code{CTA}, \code{DNN}, \code{FDA}, \code{GAM}, \code{GBM}, \code{GLM}, \code{MARS}, 
\code{MAXENT}, \code{MAXNET}, \code{RF}, \code{RFd}, \code{SRE}, \code{XGBOOST}}

\item{strategy}{a \code{character} corresponding to the method to select models' parameters 
values, must be either \code{default}, \code{bigboss}, \code{user.defined}, \code{tuned} 
(see Details)}

\item{user.val}{(\emph{optional, default} \code{NULL}) \cr
A \code{list} containing parameters values for some (all) models}

\item{user.base}{(\emph{optional, default} \code{bigboss}) \cr
If \code{strategy = 'user.defined'}, a \code{character} corresponding to the basic set of 
options to be modified by user defined values, must be either \code{default} or \code{bigboss} 
(see Details)}

\item{bm.format}{(\emph{optional, default} \code{NULL}) \cr
A \code{\link{BIOMOD.formated.data}} or \code{\link{BIOMOD.formated.data.PA}} object returned 
by the \code{\link{BIOMOD_FormatingData}} function}

\item{calib.lines}{(\emph{optional, default} \code{NULL}) \cr
A \code{data.frame} object returned by \code{\link{get_calib_lines}} or 
\code{\link{bm_CrossValidation}} functions}
}
\value{
A \code{\link{BIOMOD.models.options}} of object that can be used to build species 
distribution model(s) with the \code{\link{BIOMOD_Modeling}} function.
}
\description{
Parameterize and/or tune \pkg{biomod2}'s single models options.
}
\details{
This function creates a \code{\link{BIOMOD.models.options}} object containing parameter values 
for each single model that can be run within \pkg{biomod2} through 
\code{\link{BIOMOD_Modeling}} function.

11 different algorithms are currently available, with different versions for some (\code{GAM}, 
\code{MAXENT}, \code{RF}). These models are associated with \emph{binary} or \emph{nonbinary} 
datatypes, but all combinations are not available. They are all listed within the 
\code{\link{ModelsTable}} dataset.

Different strategies are available to set those parameters, through the \code{strategy} 
argument :
\describe{
  \item{default}{all parameters names and values are directly retrieve from functions to be 
  called through \code{\link[methods]{formalArgs}} and \code{\link{formals}} functions}
  \item{bigboss}{default parameter values are updated with values predefined by \pkg{biomod2} 
  team (see \code{\link{OptionsBigboss}})}
  \item{user.defined}{default parameter values are updated with values provided by the user}
  \item{tuned}{default parameter values are updated by calling \code{\link{bm_Tuning}} 
  function}
}

To define the same options for all datasets of a model, options can be provided through the 
\code{user.val} parameter as a \code{list} whose name is \code{for_all_datasets}.
}
\note{
\code{MAXENT} being the only external model (not called through a \code{R} package), 
default parameters, and their values, are the following : \cr \cr

\tabular{ccl}{
  \strong{FLAG} \tab \strong{default} \tab \strong{Description}  \cr
  
  \code{path_to_maxent.jar} \tab getwd() \tab a \code{character} corresponding to path to 
  \code{maxent.jar} file \cr
  \code{memory_allocated} \tab 512 \tab an \code{integer} corresponding to the amount of memory 
  (in Mo) reserved for \code{java} to run \code{MAXENT}, must be either \code{64}, 
  \code{128}, \code{256}, \code{512}, \code{1024}... or \code{NULL} to use default \code{java}
  memory limitation parameter \cr
  
  \code{initial_heap_size} \tab NULL \tab a \code{character} corresponding to initial heap 
  space (shared memory space) allocated to \code{java} (argument \code{-Xms} when calling 
  \code{java}), must be either \code{1024K}, \code{4096M}, \code{10G} ... or \code{NULL} to 
  use default \code{java} parameter. Used in \code{\link{BIOMOD_Projection}} but not in 
  \code{\link{BIOMOD_Modeling}}. \cr
  \code{max_heap_size} \tab NULL \tab a \code{character} corresponding to maximum heap 
  space (shared memory space) allocated to \code{java} (argument \code{-Xmx} when calling 
  \code{java}), must be either \code{1024K}, \code{4096M}, \code{10G} ... or \code{NULL} to 
  use default \code{java} parameter, and must be larger than \code{initial_heap_size}. Used 
  in \code{\link{BIOMOD_Projection}} but not in \code{\link{BIOMOD_Modeling}}. \cr
  
  \code{background_data_dir} \tab 'default' \tab a \code{character} corresponding to path 
  to folder where explanatory variables are stored as \code{ASCII} files (raster format). 
  If specified, \code{MAXENT} will generate its own background data from rasters of 
  explanatory variables (\code{'default'} value). Otherwise \pkg{biomod2} pseudo-absences
  will be used (see \code{\link{BIOMOD_FormatingData}}). \cr
  \code{visible} \tab FALSE \tab a \code{logical} value defining whether \code{MAXENT} 
  user interface is to be used or not \cr
  
  \code{linear} \tab TRUE \tab a \code{logical} value defining whether linear features are 
  to be used or not \cr
  \code{quadratic} \tab TRUE \tab a \code{logical} value defining whether quadratic features are 
  to be used or not \cr
  \code{product} \tab TRUE \tab a \code{logical} value defining whether product features are 
  to be used or not \cr
  \code{threshold} \tab TRUE \tab a \code{logical} value defining whether threshold features are 
  to be used or not \cr
  \code{hinge} \tab TRUE \tab a \code{logical} value defining whether hinge features are 
  to be used or not \cr
  
  \code{l2lqthreshold} \tab 10 \tab an \code{integer} corresponding to the number of 
  samples at which quadratic features start being used \cr
  \code{lq2lqptthreshold} \tab 80 \tab an \code{integer} corresponding to the number of 
  samples at which product and threshold features start being used \cr
  \code{hingethreshold} \tab 15 \tab an \code{integer} corresponding to the number of 
  samples at which hinge features start being used \cr
  
  \code{beta_lqp} \tab -1.0 \tab a \code{numeric} corresponding to the regularization 
  parameter to be applied to all linear, quadratic and product features (\emph{negative value 
  enables automatic setting}) \cr
  \code{beta_threshold} \tab -1.0 \tab a \code{numeric} corresponding to the regularization 
  parameter to be applied to all threshold features (\emph{negative value enables automatic 
  setting}) \cr
  \code{beta_hinge} \tab -1.0 \tab a \code{numeric} corresponding to the regularization 
  parameter to be applied to all hinge features (\emph{negative value enables automatic 
  setting}) \cr
  \code{beta_categorical} \tab -1.0 \tab a \code{numeric} corresponding to the regularization 
  parameter to be applied to all categorical features (\emph{negative value enables automatic 
  setting}) \cr
  
  \code{betamultiplier} \tab 1 \tab a \code{numeric} corresponding to the number by which 
  multiply all automatic regularization parameters (\emph{higher number gives a more 
  spread-out distribution}) \cr
  
  \code{defaultprevalence} \tab 0.5 \tab a \code{numeric} corresponding to the default 
  prevalence of the modelled species (\emph{probability of presence at ordinary occurrence 
  points}) \cr
  
  \code{togglelayerselected} \tab NULL \tab a \code{character} defining the prefix to be used 
  to REMOVE environmental layers whose names begin with this prefix (\emph{all selected by 
  default}) \cr
  \code{maximumbackground} \tab 10000 \tab an \code{integer} corresponding to the maximum 
  number of pixels to be selected randomly among background points if larger than this number \cr
  \code{maximumiterations} \tab 500 \tab an \code{integer} corresponding to the maximum number 
  of iterations for training \cr
  \code{convergencethreshold} \tab 0.00005 \tab a \code{numeric} corresponding to the drop in 
  log loss per iteration below which the training will be stopped \cr
  \code{autofeature} \tab TRUE \tab a \code{logical} value defining whether feature classes 
  to be used will automatically be selected based on number of training samples or not \cr
  \code{jackknife} \tab FALSE \tab a \code{logical} value defining whether variables' 
  importance is to be measured or not. If selected, training will be done with each 
  environmental variable first omitted then used in isolation. \cr
  \code{writeclampgrid} \tab FALSE \tab a \code{logical} value defining whether clamping mask 
  is to be saved or not (\emph{absolute difference between prediction values with and without 
  clamping}) \cr
  \code{writemess} \tab FALSE \tab a \code{logical} value defining whether multidimensional 
  environmental similarity surface (MESS) is to be saved or not (\emph{degree of novelness of 
  environmental conditions; and which variable is the most out of range at each point}) \cr
  \code{logfile} \tab 'maxent.log' \tab a \code{character} corresponding to file name in which 
  debugging information will be written \cr
  \code{verbose} \tab FALSE \tab a \code{logical} value defining whether detailed diagnostics 
  for debugging should be given or not \cr
}
}
\examples{
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

# ---------------------------------------------------------------#
# Format Data with true absences
myBiomodData <- BIOMOD_FormatingData(resp.name = myRespName,
                                     resp.var = myResp,
                                     resp.xy = myRespXY,
                                     expl.var = myExpl)

# k-fold selection
cv.k <- bm_CrossValidation(bm.format = myBiomodData,
                           strategy = 'kfold',
                           nb.rep = 2,
                           k = 3)


# ---------------------------------------------------------------#
allModels <- c('ANN', 'CTA', 'DNN', 'FDA', 'GAM', 'GBM', 'GLM', 'MARS'
               , 'MAXENT', 'MAXNET', 'RF', 'RFd', 'SRE', 'XGBOOST')

# default parameters
opt.d <- bm_ModelingOptions(data.type = 'binary',
                            models = allModels,
                            strategy = 'default')

# providing formated data
opt.df <- bm_ModelingOptions(data.type = 'binary',
                             models = allModels,
                             strategy = 'default',
                             bm.format = myBiomodData,
                             calib.lines = cv.k)

opt.d
opt.d@models
opt.d@options$ANN.binary.nnet.nnet
names(opt.d@options$ANN.binary.nnet.nnet@args.values)

opt.df@options$ANN.binary.nnet.nnet
names(opt.df@options$ANN.binary.nnet.nnet@args.values)


# ---------------------------------------------------------------#
# bigboss parameters
opt.b <- bm_ModelingOptions(data.type = 'binary',
                            models = allModels,
                            strategy = 'bigboss')

# user defined parameters
user.SRE <- list('_allData_allRun' = list(quant = 0.01))
user.XGBOOST <- list('_allData_allRun' = list(nrounds = 10))
user.val <- list(SRE.binary.biomod2.bm_SRE = user.SRE
                 , XGBOOST.binary.xgboost.xgb_train = user.XGBOOST)

opt.u <- bm_ModelingOptions(data.type = 'binary',
                            models = c('SRE', 'XGBOOST'),
                            strategy = 'user.defined',
                            user.val = user.val)

opt.b
opt.u

\dontrun{
# tuned parameters with formated data
opt.t <- bm_ModelingOptions(data.type = 'binary',
                            models = c('SRE', 'XGBOOST'),
                            strategy = 'tuned',
                            bm.format = myBiomodData)
opt.t
}



}
\seealso{
\code{\link{ModelsTable}}, \code{\link{OptionsBigboss}}, 
\code{\link{BIOMOD.models.options}}, 
\code{\link{bm_Tuning}}, \code{\link{BIOMOD_Modeling}}

Other Secondary functions: 
\code{\link{bm_BinaryTransformation}()},
\code{\link{bm_CrossValidation}()},
\code{\link{bm_FindOptimStat}()},
\code{\link{bm_MakeFormula}()},
\code{\link{bm_ModelAnalysis}()},
\code{\link{bm_PlotEvalBoxplot}()},
\code{\link{bm_PlotEvalMean}()},
\code{\link{bm_PlotRangeSize}()},
\code{\link{bm_PlotResponseCurves}()},
\code{\link{bm_PlotVarImpBoxplot}()},
\code{\link{bm_PseudoAbsences}()},
\code{\link{bm_RangeSize}()},
\code{\link{bm_RunModelsLoop}()},
\code{\link{bm_SRE}()},
\code{\link{bm_SampleBinaryVector}()},
\code{\link{bm_SampleFactorLevels}()},
\code{\link{bm_Tuning}()},
\code{\link{bm_VariablesImportance}()}
}
\author{
Damien Georges, Wilfried Thuiller, Maya Guéguen
}
\concept{Secondary functions}
\keyword{models}
\keyword{options}
