\name{commonprob2sigma}
\alias{commonprob2sigma}
\title{Calculate a Covariance Matrix for the Normal Distribution from
  a Matrix of Joint Probabilities}
\usage{
commonprob2sigma(commonprob, simulvals)
}
\arguments{
  \item{commonprob}{matrix of pairwise probabilities.}
  \item{simulvals}{array received by \code{simul.commonprob}.}
}
\description{
  Computes a covariance matrix for a normal distribution which
  corresponds to a binary distribution with marginal probabilities given
  by \code{diag(commonprob)} and pairwise probabilities given by
  \code{commonprob}. 

  For the simulations the values of \code{simulvals} are used.

  If a non-valid covariance matrix is the result, the program stops with
  an error in the case of NA arguments and yields are warning message if
  the matrix is not positive definite.
}
\value{
  A covariance matrix is returned with the same dimensions as
  \code{commonprob}. 
}
\references{
  \bibshow{bindata::Leisch+Weingessel+Hornik:1998}
}
\author{Friedrich Leisch}
\seealso{
  \code{\link{simul.commonprob}}
}
\examples{
m <- cbind(c(1/2,1/5,1/6),c(1/5,1/2,1/6),c(1/6,1/6,1/2))
sigma <- commonprob2sigma(m)
}
\keyword{distribution}
\keyword{multivariate}
