% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataFunctions.R
\name{continueRecruitment}
\alias{continueRecruitment}
\title{continueRecruitment}
\usage{
continueRecruitment(n_subjects_add_list, decisions_list, method_name = NULL)
}
\arguments{
\item{n_subjects_add_list}{A list that contains for each scenario an integer vector for
the number of subjects per cohort to be additionally recruited.}

\item{decisions_list}{A list with decisions per scenario created with
\code{\link[bhmbasket]{getGoDecisions}}}

\item{method_name}{A string for the method name of the analysis the decisions are based on.
Can be \code{NULL} if only one method has been used for analysis, Default: \code{NULL}}
}
\value{
An object of class \code{scenario_list} with the scenario data for each specified scenario.
}
\description{
This function continues the recruitment of subjects for a set of scenarios
based on the Go / NoGo decisions in the simulated trial outcomes of said scenarios.
}
\details{
This function is intended to be used for analyses with the following work flow:\cr
\code{simulateScenarios()} -> \code{performAnalyses()} -> \code{getGoDecisions()}-> \cr
\code{continueRecruitment()} -> \code{performAnalyses()} -> \code{getGoDecisions()}-> \cr
\code{continueRecruitment()} -> ...

Note that \code{n_subjects_add_list} takes the additional number of subjects to be recruited,
not the overall number of subjects.
This way the work flow can be repeated as often as
required, which can be useful e.g. for interim analyses.
}
\examples{
interim_scenarios <- simulateScenarios(
  n_subjects_list     = list(c(10, 20, 30)),
  response_rates_list = list(rep(0.9, 3)),
  n_trials            = 10)

interim_analyses <- performAnalyses(
  scenario_list       = interim_scenarios,
  target_rates        = rep(0.5, 3),
  n_mcmc_iterations   = 100)

interim_gos <- getGoDecisions(
  analyses_list       = interim_analyses,
  cohort_names        = c("p_1", "p_2", "p_3"),
  evidence_levels     = c(0.5, 0.8, 0.5),
  boundary_rules      = quote(c(x[1] > 0.8, x[2] > 0.6, x[3] > 0.7)))

scenarios_list <- continueRecruitment(
  n_subjects_add_list = list(c(30, 20, 10)),
  decisions_list      = interim_gos,
  method_name         = "exnex_adj")
}
\seealso{
\code{\link[bhmbasket]{simulateScenarios}}
\code{\link[bhmbasket]{performAnalyses}}
\code{\link[bhmbasket]{getGoDecisions}}
}
\author{
Stephan Wojciekowski
}
