% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{confint.brs}
\alias{confint.brs}
\title{Wald confidence intervals}
\usage{
\method{confint}{brs}(
  object,
  parm,
  level = 0.95,
  model = c("full", "mean", "precision"),
  ...
)
}
\arguments{
\item{object}{A fitted \code{"betaregscale"} object.}

\item{parm}{Character or integer: which parameters. If missing,
all parameters are returned.}

\item{level}{Confidence level (default 0.95).}

\item{model}{Character: \code{"full"}, \code{"mean"}, or
\code{"precision"}.}

\item{...}{Currently ignored.}
}
\value{
Matrix with columns for lower and upper confidence bounds.
}
\description{
Computes Wald confidence intervals for model parameters using the
normal approximation.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
confint(fit)
confint(fit, model = "mean")
}

}
\seealso{
\code{\link{brs}}, \code{\link{coef.brs}}, \code{\link{vcov.brs}},
  \code{\link{brs_est}}
}
