% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.brs_marginaleffects}
\alias{autoplot.brs_marginaleffects}
\title{ggplot2 autoplot for marginal effects}
\usage{
\method{autoplot}{brs_marginaleffects}(
  object,
  type = c("forest", "magnitude", "dist"),
  variable = NULL,
  top_n = 12L,
  title = NULL,
  caption = NULL,
  theme = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{"brs_marginaleffects"}.}

\item{type}{Plot type: \code{"forest"}, \code{"magnitude"}, or \code{"dist"}.}

\item{variable}{Optional variable name for \code{type = "dist"}.}

\item{top_n}{Maximum number of variables shown in \code{"magnitude"}
(ordered by \code{|AME|}).}

\item{title}{Optional plot title override.}

\item{caption}{Optional subtitle override.}

\item{theme}{Optional ggplot2 theme object. If \code{NULL},
\code{ggplot2::theme_minimal()} is used.}

\item{...}{Currently ignored.}
}
\value{
A \code{ggplot2} object.
}
\description{
Produces visual summaries for objects returned by
\code{\link{brs_marginaleffects}}.
}
\details{
\code{type = "dist"} requires AME simulation draws stored in
\code{attr(object, "ame_draws")}, which are available when marginal
effects are computed with \code{keep_draws = TRUE} and \code{interval = TRUE}.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
ame <- brs_marginaleffects(fit)
ggplot2::autoplot(ame, type = "forest")
}

}
\seealso{
\code{\link{brs_marginaleffects}}, \code{\link{brs}},
  \code{\link{autoplot.brs}}
}
