% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{summary.bayesianVARs_predict}
\alias{summary.bayesianVARs_predict}
\title{Summary method for bayesianVARs_predict objects}
\usage{
\method{summary}{bayesianVARs_predict}(object, ...)
}
\arguments{
\item{object}{A \code{bayesianVARs_predict} object obtained via
\code{\link[=predict.bayesianVARs_bvar]{predict.bayesianVARs_bvar()}}.}

\item{...}{Currently ignored!}
}
\value{
A \code{summary.bayesianVARs_predict} object.
}
\description{
Summary method for \code{bayesianVARs_predict} objects.
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]

# Split data in train and test
train <- data[1:(nrow(data)-4),]
test <- data[-c(1:(nrow(data)-4)),]

# Estimate model using train data only
mod <- bvar(train, quiet = TRUE)

# Simulate from 1-step ahead posterior predictive
predictions <- predict(mod, ahead = 1L)
summary(predictions)
}
