% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default-credential.R
\name{credential_chain}
\alias{credential_chain}
\title{Create Custom Credential Chain}
\usage{
credential_chain(...)
}
\arguments{
\item{...}{Named credential objects or credential classes. Each element
should be a credential class (e.g., \code{ClientSecretCredential}) or an
instantiated credential object that inherits from the \code{Credential}
base class. The names are used for identification purposes.}
}
\value{
A \code{credential_chain} object containing the specified sequence
of credential providers.
}
\description{
Creates a custom chain of credential providers to attempt during
authentication. Credentials are tried in the order they are provided
until one successfully authenticates. This allows you to customize
the authentication flow beyond the default credential chain.
}
\examples{
# Create a custom chain with only non-interactive credentials
custom_chain <- credential_chain(
  client_secret = ClientSecretCredential,
  azure_cli = AzureCLICredential
)

# Use the custom chain to get a token
\dontrun{
token <- get_token(
  scope = "https://graph.microsoft.com/.default",
  chain = custom_chain
)
}

}
\seealso{
\code{\link[=default_credential_chain]{default_credential_chain()}}, \code{\link[=get_token_provider]{get_token_provider()}}
}
