% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential-azure-cli.R
\name{AzureCLICredential}
\alias{AzureCLICredential}
\title{Azure CLI credential authentication}
\description{
Authenticates using the Azure CLI (\code{az}) command-line tool. This credential
requires the Azure CLI to be installed and the user to be logged in via
\verb{az login}.
}
\details{
The credential uses the \verb{az account get-access-token} command to retrieve
access tokens. It will use the currently active Azure CLI account and
subscription unless a specific tenant is specified.
}
\examples{
# Create credential with default settings
cred <- AzureCLICredential$new()

# Create credential with specific scope and tenant
cred <- AzureCLICredential$new(
  scope = "https://management.azure.com/.default",
  tenant_id = "your-tenant-id"
)

# To get a token or authenticate a request it is required that
# 'az login' is successfully executed, otherwise it will return an error.
\dontrun{
# Get an access token
token <- cred$get_token()

# Use with httr2 request
req <- httr2::request("https://management.azure.com/subscriptions")
resp <- httr2::req_perform(cred$req_auth(req))
}
}
\section{Super classes}{
\code{azr::Credential} -> \code{\link[azr:InteractiveCredential]{azr::InteractiveCredential}} -> \code{AzureCLICredential}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.process_timeout}}{Timeout in seconds for Azure CLI command execution}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AzureCLICredential-new}{\code{AzureCLICredential$new()}}
\item \href{#method-AzureCLICredential-get_token}{\code{AzureCLICredential$get_token()}}
\item \href{#method-AzureCLICredential-req_auth}{\code{AzureCLICredential$req_auth()}}
\item \href{#method-AzureCLICredential-account_show}{\code{AzureCLICredential$account_show()}}
\item \href{#method-AzureCLICredential-login}{\code{AzureCLICredential$login()}}
\item \href{#method-AzureCLICredential-logout}{\code{AzureCLICredential$logout()}}
\item \href{#method-AzureCLICredential-clone}{\code{AzureCLICredential$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="azr" data-topic="Credential" data-id="print"><a href='../../azr/html/Credential.html#method-Credential-print'><code>azr::Credential$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="azr" data-topic="Credential" data-id="validate"><a href='../../azr/html/Credential.html#method-Credential-validate'><code>azr::Credential$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="azr" data-topic="InteractiveCredential" data-id="is_interactive"><a href='../../azr/html/InteractiveCredential.html#method-InteractiveCredential-is_interactive'><code>azr::InteractiveCredential$is_interactive()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AzureCLICredential-new"></a>}}
\if{latex}{\out{\hypertarget{method-AzureCLICredential-new}{}}}
\subsection{Method \code{new()}}{
Create a new Azure CLI credential
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AzureCLICredential$new(
  scope = NULL,
  tenant_id = NULL,
  process_timeout = NULL,
  interactive = FALSE,
  use_bridge = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scope}}{A character string specifying the OAuth2 scope. Defaults to
\code{NULL}, which uses the scope set during initialization.}

\item{\code{tenant_id}}{A character string specifying the Azure Active Directory
tenant ID. Defaults to \code{NULL}, which uses the default tenant from Azure CLI.}

\item{\code{process_timeout}}{A numeric value specifying the timeout in seconds
for the Azure CLI process. Defaults to \code{10}.}

\item{\code{interactive}}{A logical value indicating whether to check if the user is
logged in and perform login if needed. Defaults to \code{FALSE}.}

\item{\code{use_bridge}}{A logical value indicating whether to use the device code
bridge webpage during login. If \code{TRUE}, launches an intermediate local webpage
that displays the device code and facilitates copy-pasting before redirecting
to the Microsoft device login page. Only used when \code{interactive = TRUE}. Defaults to \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{AzureCLICredential} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AzureCLICredential-get_token"></a>}}
\if{latex}{\out{\hypertarget{method-AzureCLICredential-get_token}{}}}
\subsection{Method \code{get_token()}}{
Get an access token from Azure CLI
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AzureCLICredential$get_token(scope = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scope}}{A character string specifying the OAuth2 scope. If \code{NULL},
uses the scope specified during initialization.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{\link[httr2:oauth_token]{httr2::oauth_token()}} object containing the access token
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AzureCLICredential-req_auth"></a>}}
\if{latex}{\out{\hypertarget{method-AzureCLICredential-req_auth}{}}}
\subsection{Method \code{req_auth()}}{
Add authentication to an httr2 request
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AzureCLICredential$req_auth(req, scope = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{req}}{An \code{\link[httr2:request]{httr2::request()}} object}

\item{\code{scope}}{A character string specifying the OAuth2 scope. If \code{NULL},
uses the scope specified during initialization.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The request object with authentication header added
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AzureCLICredential-account_show"></a>}}
\if{latex}{\out{\hypertarget{method-AzureCLICredential-account_show}{}}}
\subsection{Method \code{account_show()}}{
Show the currently active Azure CLI account information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AzureCLICredential$account_show(timeout = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{timeout}}{A numeric value specifying the timeout in seconds for the
Azure CLI command. If \code{NULL}, uses the process timeout specified during
initialization.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list containing the account information from Azure CLI
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AzureCLICredential-login"></a>}}
\if{latex}{\out{\hypertarget{method-AzureCLICredential-login}{}}}
\subsection{Method \code{login()}}{
Perform Azure CLI login using device code flow
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AzureCLICredential$login()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Invisibly returns the exit status (0 for success, non-zero for failure)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AzureCLICredential-logout"></a>}}
\if{latex}{\out{\hypertarget{method-AzureCLICredential-logout}{}}}
\subsection{Method \code{logout()}}{
Log out from Azure CLI
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AzureCLICredential$logout()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Invisibly returns \code{NULL}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AzureCLICredential-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AzureCLICredential-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AzureCLICredential$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
