% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SamplingVAE.R
\name{Encoder_weights}
\alias{Encoder_weights}
\title{Extract encoder-only weights from a trained Keras model}
\usage{
Encoder_weights(
  encoder_layers,
  trained_model,
  lip_enc,
  pi_enc,
  BNenc_layers,
  learn_BN
)
}
\arguments{
\item{encoder_layers}{Integer. Number of encoder layers (used to compute split index).}

\item{trained_model}{Keras model. Typically \code{training$trained_model} from \code{\link[=VAE_train]{VAE_train()}}.}

\item{lip_enc}{Integer (0/1). Whether spectral normalization was used in the encoder.}

\item{pi_enc}{Integer. Power iteration count if spectral normalization was used.}

\item{BNenc_layers}{Integer. Number of encoder layers that had batch normalization.}

\item{learn_BN}{Integer (0/1). Whether BN layers learned scale and center.}
}
\value{
A \code{list()} of encoder weight tensors in order, suitable for \code{set_weights()}.
}
\description{
Pulls just the \strong{encoder} weights from \code{keras::get_weights(trained_model)},
skipping any parameters introduced by batch normalization (BN) or spectral
normalization (SN). The split index is computed from the number of encoder
layers and whether BN/SN were used.
}
\details{
\itemize{
\item The index arithmetic assumes AutoTab's standard Dense/BN/SN layout. If you
substantially change layer ordering or introduce new per-layer parameters,
re-check the split index.
\item All model weights can always be accessed directly using
\code{keras::get_weights(trained_model)}. This function is provided as a
convenience tool within AutoTab to streamline encoder reconstruction but
is not the only method available.
}
}
\examples{
encoder_info <- list(
  list("dense", 100, "relu"),
  list("dense",  80, "relu")
)

 \donttest{
if (reticulate::py_module_available("tensorflow") &&
    exists("training")) {
weights_encoder <- Encoder_weights(
  encoder_layers = 2,
  trained_model  = training$trained_model, #where training = VAE_train(...)
  lip_enc        = 0,
  pi_enc         = 0,
  BNenc_layers   = 0,
  learn_BN       = 0
)
}
}

}
\seealso{
\code{\link[=encoder_latent]{encoder_latent()}}, \code{\link[=Decoder_weights]{Decoder_weights()}}, \code{\link[=VAE_train]{VAE_train()}}, \code{\link[=Latent_sample]{Latent_sample()}}
}
