% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_change_size}
\alias{am_change_size}
\title{Get the number of operations in a change}
\usage{
am_change_size(change)
}
\arguments{
\item{change}{An \code{am_change} object (from \code{\link[=am_get_changes]{am_get_changes()}} or
\code{\link[=am_change_from_bytes]{am_change_from_bytes()}})}
}
\value{
An integer (or double for very large values exceeding R's 32-bit
integer range)
}
\description{
Returns the number of operations contained in the change. Useful for
estimating the size of changes before syncing or storing them.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "x", 1)
am_put(doc, AM_ROOT, "y", 2)
am_commit(doc, "Add keys")

history <- am_get_changes(doc)
am_change_size(history[[1]])  # 2

am_close(doc)

}
