% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_basic.R
\name{anova_rbd}
\alias{anova_rbd}
\title{Randomized Block Design (RBD) ANOVA}
\usage{
anova_rbd(
  data,
  response,
  treatment,
  block,
  posthoc = "lsd",
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing the experimental data}

\item{response}{Name of the response variable}

\item{treatment}{Name of treatment factor}

\item{block}{Name of block/replication factor}

\item{posthoc}{Post-hoc test: "lsd", "duncan", "tukey", "snk", "scheffe", or "all"}

\item{alpha}{Significance level (default 0.05)}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA table, means, post-hoc results
}
\description{
Performs complete ANOVA for Randomized Block Design (RCBD) with post-hoc tests,
assumptions checking, and publication-ready output.
}
\examples{
data <- data.frame(
  rep = rep(1:4, each = 5),
  treatment = rep(c("T1", "T2", "T3", "T4", "T5"), 4),
  yield = c(rnorm(5, 1200, 50), rnorm(5, 1250, 55),
            rnorm(5, 1180, 45), rnorm(5, 1270, 60))
)
anova_rbd(data, response = "yield", treatment = "treatment", 
          block = "rep", posthoc = "duncan")

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
