% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_additional.R
\name{anova_factorial_3way}
\alias{anova_factorial_3way}
\title{Three-Factor Factorial ANOVA}
\usage{
anova_factorial_3way(
  data,
  response,
  factor1,
  factor2,
  factor3,
  replication = NULL,
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing the data}

\item{response}{Name of the response variable}

\item{factor1}{Name of first factor (A)}

\item{factor2}{Name of second factor (B)}

\item{factor3}{Name of third factor (C)}

\item{replication}{Name of replication factor (optional)}

\item{alpha}{Significance level}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA results
}
\description{
Performs three-factor factorial ANOVA with all interactions.
}
\examples{
data <- expand.grid(rep = 1:3, A = c("A1", "A2"), B = c("B1", "B2"), C = c("C1", "C2"))
data$yield <- rnorm(nrow(data), 1200, 150)
anova_factorial_3way(data, "yield", "A", "B", "C", "rep")

}
\author{
Lalit Kumar Rolaniya, Ram Lal Jat, Monika Punia, Raja Ram Choudhary
}
