% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{confint_from_sigma}
\alias{confint_from_sigma}
\title{Function to compute the confidence intervals from a variance-covariance matrix}
\usage{
confint_from_sigma(sigma, theta, level = 0.95)
}
\arguments{
\item{sigma}{either the variance-covariance matrix or the vector of variances
of the parameter estimator}

\item{theta}{the point estimate}

\item{level}{confidence level, defaults to 0.95 (alpha=.05)}
}
\value{
Matrix of confidence intervals with rows for each parameter and
  columns for lower and upper bounds.
}
\description{
Function to compute the confidence intervals from a variance-covariance matrix
}
\examples{
# Compute CI for a bivariate parameter
theta <- c(mu = 5.2, sigma2 = 4.1)
vcov_matrix <- diag(c(0.1, 0.5))  # Variance of estimators

confint_from_sigma(vcov_matrix, theta)
confint_from_sigma(vcov_matrix, theta, level = 0.99)
}
