% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvn.R
\name{rmap.mvn}
\alias{rmap.mvn}
\title{Computes the distribution of \code{g(x)} where \code{x} is an \code{mvn} object.}
\usage{
\method{rmap}{mvn}(x, g, n = 10000L, ...)
}
\arguments{
\item{x}{The \code{mvn} object to apply \code{g} to}

\item{g}{The function to apply to \code{x}}

\item{n}{number of samples to take to estimate distribution of \code{g(x)} if
\code{method} is \code{mc} or \code{empirical}. Defaults to 10000.}

\item{...}{additional arguments to pass into the \code{g} function.}
}
\value{
An \code{mvn} distribution fitted to the transformed samples.
}
\description{
By the invariance property, if \code{x} is an \code{mvn} object,
then under the right conditions, asymptotically, \code{g(x)} is an MVN
distributed,
g(x) ~ normal(g(mean(x)), sigma)
where \code{sigma} is the variance-covariance of \code{g(x)}
}
\examples{
\donttest{
X <- mvn(c(1, 2), diag(2))
set.seed(42)
Y <- rmap(X, function(x) x^2)
mean(Y)
}
}
