% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limits.R
\name{normal_approx}
\alias{normal_approx}
\title{Moment-Matching Normal Approximation}
\usage{
normal_approx(x)
}
\arguments{
\item{x}{A \code{dist} object to approximate.}
}
\value{
A \code{normal} distribution (for univariate inputs) or an
\code{mvn} distribution (for multivariate inputs) with the same
mean and variance-covariance as \code{x}.
}
\description{
Constructs a normal (or multivariate normal) distribution that matches
the mean and variance-covariance of the input distribution. This is
useful as a quick Gaussian approximation for any distribution whose
first two moments are available.
}
\examples{
# Approximate a Gamma(5, 2) with a normal
g <- gamma_dist(shape = 5, rate = 2)
n <- normal_approx(g)
mean(n)
vcov(n)
}
