% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_dist.R
\name{expectation.poisson_dist}
\alias{expectation.poisson_dist}
\title{Exact expectation for a Poisson distribution.}
\usage{
\method{expectation}{poisson_dist}(x, g, ...)
}
\arguments{
\item{x}{A \code{poisson_dist} object.}

\item{g}{A function to take the expectation of.}

\item{...}{Additional arguments passed to \code{g}.}
}
\value{
The expected value \eqn{E[g(X)]}.
}
\description{
Computes \eqn{E[g(X)]} using truncated summation over the support.
The summation is truncated at the \eqn{1 - 10^{-12}} quantile to
ensure negligible truncation error.
}
\examples{
x <- poisson_dist(5)
expectation(x, identity)
expectation(x, function(k) k^2)
}
