% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvn.R
\name{density.mvn}
\alias{density.mvn}
\title{Function generator for obtaining the pdf of an \code{mvn} object (multivariate
normal).}
\usage{
\method{density}{mvn}(x, ...)
}
\arguments{
\item{x}{The \code{mvn} (S3) object to obtain the pdf (density) of}

\item{...}{Additional arguments to pass into the generated function.}
}
\value{
A function that computes the pdf of the \code{mvn} distribution.
It accepts as input:
- \code{obs}: vector or matrix of quantiles. when x is a matrix, each row
is taken to be a quantile and columns correspond to the number of
dimensions, p.
- \code{mu}: a a vector denoting the population mean. Defaults to the
mean of \code{x} (an \code{mvn} object)
- \code{sigma}: a matrix denoting the variance-covariance of
observations. Defaults to the variance-covariance of \code{x}.
- \code{log}: logical, determines whether to compute the log of the pdf.
Defaults to \code{FALSE}.
- \code{...}: any additional parameters to pass to \code{dmvnorm}.
}
\description{
Function generator for obtaining the pdf of an \code{mvn} object (multivariate
normal).
}
\examples{
X <- mvn(c(0, 0), diag(2))
f <- density(X)
f(c(0, 0))
f(c(1, 1))
}
