% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture.R
\name{density.mixture}
\alias{density.mixture}
\title{Probability density function for a mixture distribution.}
\usage{
\method{density}{mixture}(x, ...)
}
\arguments{
\item{x}{A \code{mixture} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(t, log = FALSE, ...)} returning the
density (or log-density) at \code{t}.
}
\description{
Returns a function that evaluates the mixture density at given points.
The mixture density is \eqn{f(x) = \sum_k w_k f_k(x)}.
}
\examples{
m <- mixture(list(normal(0, 1), normal(5, 1)), c(0.5, 0.5))
f <- density(m)
f(0)
f(2.5)
}
