% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limits.R
\name{clt}
\alias{clt}
\title{Central Limit Theorem Limiting Distribution}
\usage{
clt(base_dist)
}
\arguments{
\item{base_dist}{A \code{dist} object representing the base distribution.}
}
\value{
A \code{normal} or \code{mvn} distribution representing the
CLT limiting distribution.
}
\description{
Returns the limiting distribution of the standardized sample mean
\eqn{\sqrt{n}(\bar{X}_n - \mu)} under the Central Limit Theorem.
For a univariate distribution with variance \eqn{\sigma^2}, this is
\eqn{N(0, \sigma^2)}. For a multivariate distribution with covariance
matrix \eqn{\Sigma}, this is \eqn{MVN(0, \Sigma)}.
}
\examples{
# CLT for Exp(2): sqrt(n)(Xbar - 1/2) -> N(0, 1/4)
x <- exponential(rate = 2)
z <- clt(x)
mean(z)
vcov(z)
}
