% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_dist.R
\name{cdf.weibull_dist}
\alias{cdf.weibull_dist}
\title{Cumulative distribution function for a Weibull distribution.}
\usage{
\method{cdf}{weibull_dist}(x, ...)
}
\arguments{
\item{x}{A \code{weibull_dist} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(q, log.p = FALSE, ...)} returning the
CDF (or log-CDF) at \code{q}.
}
\description{
Returns a function that evaluates the Weibull CDF at given points.
}
\examples{
x <- weibull_dist(shape = 2, scale = 3)
F <- cdf(x)
F(1)
F(3)
}
