% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empirical_dist.R
\name{cdf.empirical_dist}
\alias{cdf.empirical_dist}
\title{Method for obtaining the cdf of \code{empirical_dist} object \code{x}.}
\usage{
\method{cdf}{empirical_dist}(x, ...)
}
\arguments{
\item{x}{The empirical distribution object.}

\item{...}{Additional arguments to pass (not used))}
}
\value{
A function that takes a numeric vector \code{t} and returns the
empirical cdf of \code{x} evaluated at \code{t}.
}
\description{
If \code{x} is a multivariate empirical distribution, this function will
throw an error. It's only defined for univariate empirical distributions.
}
\examples{
ed <- empirical_dist(c(1, 2, 3, 4, 5))
Fx <- cdf(ed)
Fx(3) # 0.6
Fx(c(1, 5)) # 0.2, 1.0
}
