% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_discrete_af.R
\name{scale_colour_discrete_af}
\alias{scale_colour_discrete_af}
\title{Discrete colour scales for Analysis Function plots}
\usage{
scale_colour_discrete_af(
  palette = "categorical",
  palette_type = c("af"),
  reverse = FALSE,
  na.value = afcharts::af_pale_grey,
  ...
)
}
\arguments{
\item{palette}{Name of palette to use from \code{af_colour_palettes}; e.g.
\code{"categorical"}, \code{"sequential"}, \code{"focus"}. Default value is
\code{"categorical"}.}

\item{palette_type}{Currently only the Analysis Function palettes are
supported. Defaults to "af".}

\item{reverse}{Boolean value to indicate whether the palette should be
reversed.}

\item{na.value}{Colour to set for missing values.}

\item{...}{Additional arguments passed to scale type.}
}
\value{
ggplot2 discrete colour scale
}
\description{
Discrete colour scales for Analysis Function plots
}
\details{
If the palette is set to "categorical" or "sequential" and fewer
than the maximum number of colours are required then the colours will be
used in the correct order following the analysis function guidance.

E.g. If only two colours are required and the palette is set to
\code{"categorical"} then the \code{"categorical2"} palette will be used instead,
without warning.
}
\examples{
library(ggplot2)
library(dplyr)

economics_long \%>\%
  filter(variable \%in\% c("psavert", "uempmed")) \%>\%
  ggplot(aes(x = date, y = value, colour = variable)) +
  geom_line(linewidth = 1) +
  scale_colour_discrete_af()

}
