% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{df_trans}
\alias{df_trans}
\title{df_trans}
\usage{
df_trans(df, variable_name, transformation)
}
\arguments{
\item{df}{A data frame.}

\item{variable_name}{Name of the column to transform (string).}

\item{transformation}{Transformation type: \code{"sqrt"} or \code{"log"}.}
}
\value{
The input data frame with an additional column named
  \code{<variable_name>_sqrt} or \code{<variable_name>_log}.
}
\description{
Apply a reverse square-root or reverse log transformation to a
  numeric column and append the result as a new column.
}
\examples{
df <- data.frame(val = c(1, 4, 9, 16))
df_trans(df, "val", "sqrt")
}
