% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghg_flux.R
\name{calculate_MDF}
\alias{calculate_MDF}
\title{calculate_MDF}
\usage{
calculate_MDF(
  precision_ppm,
  closure_time_s,
  data_point_n,
  chamber_volume_m3,
  temperature_C,
  chamber_area_m2,
  pressure_pa = 101325,
  ideal_constant = 8.314,
  ghg = "co2"
)
}
\arguments{
\item{precision_ppm}{Precision of the gas analyser (ppm).}

\item{closure_time_s}{Closure time of the measurement (seconds).}

\item{data_point_n}{Number of data points recorded during the closure period.}

\item{chamber_volume_m3}{Internal volume of the chamber (m\eqn{^3}).}

\item{temperature_C}{Air temperature at the measurement location (\eqn{^\circ}C).}

\item{chamber_area_m2}{Base area of the chamber (m\eqn{^2}).}

\item{pressure_pa}{Atmospheric pressure (Pa). Default 101325.}

\item{ideal_constant}{Ideal gas constant (J mol\eqn{^{-1}} K\eqn{^{-1}}).
Default 8.314.}

\item{ghg}{Greenhouse gas type: \code{"co2"}, \code{"ch4"}, or \code{"n2o"}.
Default \code{"co2"}.}
}
\value{
A named list with \code{MDF} (numeric,
  \eqn{\mu}g m\eqn{^{-2}} h\eqn{^{-1}}) and \code{unit} (string).
}
\description{
Calculate the Minimum Detectable Flux (MDF) for a static chamber
  GHG measurement system.
}
\examples{
calculate_MDF(
  precision_ppm     = 1,
  closure_time_s    = 300,
  data_point_n      = 300,
  chamber_volume_m3 = 0.0064,
  temperature_C     = 25,
  chamber_area_m2   = 0.07
)
}
