% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuhlmannStraubModel.R
\name{buhlmannStraub}
\alias{buhlmannStraub}
\title{Buhlmann-Straub credibility model}
\usage{
buhlmannStraub(
  Yijt,
  wijt,
  MLFj,
  data,
  muHat = NULL,
  type = c("additive", "multiplicative"),
  returnData = FALSE
)
}
\arguments{
\item{Yijt}{variable name of the response variable.}

\item{wijt}{variable name of the exposure weight.}

\item{MLFj}{variable name of the risk class or cluster.}

\item{data}{an object that is coercible by \code{\link[data.table]{as.data.table}}, containing the variables in the model.}

\item{muHat}{estimate for the collective premium (portfolio mean). Default is \code{NULL} and in this case, the credibility-weighted estimator is used.}

\item{type}{specifies whether the additive or multiplicative formulation of the credibility model is used. Default is additive.}

\item{returnData}{Logical, indicates whether the data object has to be returned. Default is \code{FALSE}.}
}
\value{
An object of type \code{buhlmannStraub} with the following slots:

\item{call}{the matched call}

\item{type}{Whether additive or multiplicative credibility model is used.}

\item{Variances}{The estimated variance components. \code{Sigma} is the estimated within-group variance,
 and \code{Tau} is the estimate of the between-group variance.}

\item{Means}{The estimated averages at the portfolio level (collective premium \eqn{\hat{\mu}}) and
at the cluster level (weighted average \eqn{\bar{Y}_j}).}

\item{Weights}{The total weights \eqn{w_j} for each cluster.}

\item{Credibility}{The credibility factors \eqn{z_j} for each cluster.}

\item{Premiums}{The collective premium \eqn{\hat{\mu}} and individual premiums \eqn{\hat{V}_j} for each cluster.}

\item{Relativity}{The estimated random effects \eqn{\hat{U}_j} of each cluster.}

\item{RawResults}{Object of type \code{data.table} with all intermediate results.}

\item{fitted.values}{the fitted mean values, resulting from the model fit.}
}
\description{
Fit a credibility model using the Buhlmann-Straub model.
}
\examples{
library(actuar)
library(actuaRE)
data("hachemeister", package = "actuar")
# Prepare data
X = as.data.frame(hachemeister)
Df = reshape(X, idvar = "state",
             varying = list(paste0("ratio.", 1:12), paste0("weight.", 1:12)),
             direction = "long")
# Fit Buhlmann-Straub model
fitBS = buhlmannStraub(ratio.1, weight.1, state, Df)
summary(fitBS)
# Compare with actuar package
fit <- cm(~state, hachemeister, ratios = ratio.1:ratio.12,
          weights = weight.1:weight.12)
summary(fit)
}
\references{
Buhlmann, H. and Straub, E. (1970). Glaubwurdigkeit fur Schadensatze.
\emph{Mitteilungen der Vereinigung schweizerischer Versicherungsmathematiker}, 70, 111-133.

Buhlmann, H. and Gisler, A. (2005). \emph{A Course in Credibility Theory and its Applications}. Springer.
}
\seealso{
\code{\link{buhlmannStraub-class}}, \code{\link{plotRE}}, \code{\link{buhlmannStraubGLM}}, \code{\link{buhlmannStraubTweedie}},
 \code{\link{tweedieGLMM}}, \code{\link{adjustIntercept}}, \code{\link{BalanceProperty}}
}
