% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsilon.test.R
\name{upsilon.test}
\alias{upsilon.test}
\title{Upsilon Test of Association for Count Data}
\usage{
upsilon.test(x, log.p = FALSE)
}
\arguments{
\item{x}{a matrix or data frame of floating or integer
numbers to specify a contingency table. Entries
must be non-negative.}

\item{log.p}{a logical. If \code{TRUE}, 
the \emph{p}-value is calculated in
closed form to \strong{natural logarithm} of \emph{p}-value 
to improve numerical precision when
\emph{p}-value approaches zero.
Defaults to \code{FALSE}.}
}
\value{
A list with class \code{"htest"} containing:
\item{statistic}{the value of the Upsilon statistic.}
\item{parameter}{the degrees of freedom.}
\item{p.value}{the \emph{p}-value.}
\item{estimate}{the effect size.}
\item{method}{a character string giving the test name.}
\item{data.name}{a character string giving the name of input data.}
\item{observed}{the observed counts, a matrix copy of the input data.}
\item{expected}{the expected counts under the null
 hypothesis using the observed marginals.}
}
\description{
Performs the Upsilon test to evaluate
 association among categorical variables represented
 by a contingency table.
}
\details{
The Upsilon test is designed to promote 
 dominant function patterns. In contrast to other
 tests of association to favor all function
 patterns, it is unique in demoting non-dominant
 function patterns.
 
 Null hypothesis (\eqn{H_0}): Row and column variables are 
   statistically independent.
 
 Null population: A discrete uniform distribution,
   where each entry in the table has the same
   probability.

 Null distribution: The Upsilon test statistic 
   asymptotically follows a chi-squared distribution
   with \code{(nrow(x) - 1)(ncol(x) - 1)} degrees of freedom,
   under the null hypothesis on the null population.
   
 See \insertCite{luo2021upsilon}{Upsilon} for full 
 details of the Upsilon test.
}
\examples{
library("Upsilon")

# A contingency table with independent row and column variables
x <- matrix(
  c(1, 1, 0, 
    1, 1, 0,
    1, 1, 0), 
  nrow = 3, byrow = TRUE
 )
 
print(x)

upsilon.test(x)

# A contingency table with a non-dominant function
x <- matrix(
  c(4, 0, 0, 
    0, 1, 0,
    0, 0, 1), 
  nrow = 3, byrow = TRUE
 )
 
print(x)

upsilon.test(x)

# A contingency table with a dominant function
x <- matrix(
  c(2, 0, 0, 
    0, 2, 0,
    0, 0, 2), 
  nrow = 3, byrow = TRUE)
  
print(x)

upsilon.test(x)

# Another contingency table with a dominant function
x <- matrix(
  c(3, 0, 0, 
    0, 3, 0,
    0, 0, 0), 
  nrow = 3, byrow = TRUE)

print(x)

upsilon.test(x)
}
\references{
\insertRef{luo2021upsilon}{Upsilon}
}
