% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_limit_data_by.R
\name{set_limit_data_by}
\alias{set_limit_data_by}
\title{Set variables to limit reported data values only to those that exist rather
than fully completing all possible levels}
\usage{
set_limit_data_by(e, ...)
}
\arguments{
\item{e}{A tplyr_layer}

\item{...}{Subset of variables within by or target variables}
}
\value{
a tplyr_table
}
\description{
This function allows you to select a combination of by variables or
potentially target variables for which you only want to display values
present in the data. By default, Tplyr will create a cartesian combination of
potential values of the data. For example, if you have 2 by variables
present, then each potential combination of those by variables will have a
row present in the final table. \code{set_limit_data_by()} allows you to choose
the by variables whose combination you wish to limit to values physically
present in the available data.
}
\examples{

tplyr_table(tplyr_adpe, TRT01A) \%>\%
  add_layer(
    group_desc(AVAL, by = vars(PECAT, PARAM, AVISIT))
  ) \%>\%
  build()

tplyr_table(tplyr_adpe, TRT01A) \%>\%
  add_layer(
    group_desc(AVAL, by = vars(PECAT, PARAM, AVISIT)) \%>\%
      set_limit_data_by(PARAM, AVISIT)
  ) \%>\%
  build()

tplyr_table(tplyr_adpe, TRT01A) \%>\%
  add_layer(
    group_count(AVALC, by = vars(PECAT, PARAM, AVISIT)) \%>\%
      set_limit_data_by(PARAM, AVISIT)
  ) \%>\%
  build()

tplyr_table(tplyr_adpe, TRT01A) \%>\%
  add_layer(
    group_count(AVALC, by = vars(PECAT, PARAM, AVISIT)) \%>\%
      set_limit_data_by(PECAT, PARAM, AVISIT)
  ) \%>\%
  build()
}
