\name{cancel}
\alias{cancel}

\title{
Cancel a group of orders.
}
\description{
Cancel a group of orders based on currency name or record time.
}
\usage{
cancel(src, dst, hrs = 0, token)
}

\arguments{
  \item{src}{Source currency name ("btc", "eth", "bnb", etc).}
\item{dst}{Destination currency name ("usdt" or "rls").}

\item{hrs}{
The number of hours after which orders will be canceled. If the value is less than one hour, it is specified as a decimal (e.g., 15 minutes  is given by \code{hrs = 0.25}).
}
\item{token}{
  The token is string value obtain from user ID settings in the NOBITEX. If you are not registered on the website, please use the provided \href{https://nobitex.ir/signup/?refcode=592868}{link}.
}
}


\examples{
\dontrun{
tkn <- "CONTACT WITH AUTHOR"

# All orders recorded more than one hour ago are canceled.
cancel(" ", " ", hrs = 1, token = tkn)
}
}