getNBTX<-function(src,frame,from,to){
  
  qn <- as.numeric(as.POSIXct(to))
  q1 <- as.numeric(as.POSIXct(from))
  
  params = list(
    `symbol` = src,
    `resolution` = frame,
    `from` = as.character(round(q1,0)),
    `to` =   as.character(round(qn,0))
  )
  
  res <-content(GET("https://apiv2.nobitex.ir/market/udf/history", query = params))
  data<-res
  
  data2<-(cbind(as.numeric(data$o),as.numeric(data$h),as.numeric(data$l),as.numeric(data$c),as.numeric(data$v)))
  data3<-as.data.frame(data2)
  colnames(data3)<-c("Open","High","Low","Close","volume")
  
  dates <- seq(as.Date(to+1-nrow(data3)), length = nrow(data3), by = "days")
  data0<-xts(x = data3, order.by = dates)
  data0
}
