\name{as.sign_name}
\alias{as.sign_name}
\alias{as.sign_name.default}
\alias{as.sign_name.character}
\alias{print.sign_name}

\title{Convert Transliterated Sumerian Text to Sign Names}
\description{
Converts transliterated Sumerian text to canonical sign names in uppercase notation. This is a generic function with a method for character vectors.
}
\usage{
as.sign_name(x, ...)

\method{as.sign_name}{default}(x, ...)

\method{as.sign_name}{character}(x, mapping = NULL, ...)

\method{print}{sign_name}(x, ...)
}
\arguments{
  \item{x}{
    For \code{as.sign_name}: An object to be converted to sign names. Currently, only character vectors are supported.

    For \code{print.sign_name}: An object of class \code{"sign_name"}.
  }
  \item{mapping}{A data frame containing the sign mapping table with columns \code{syllables}, \code{name}, and \code{cuneiform}. If \code{NULL} (the default), the package's internal mapping file \file{etcsl_mapping.txt} is loaded. Only used by the character method.}
  \item{...}{Additional arguments passed to methods.}
}
\details{
The function processes each element of the input character vector by:
\enumerate{
  \item Calling \code{\link{info}} to look up sign information for each transliterated sign.
  \item Extracting the canonical sign names for each sign.
  \item Reconstructing the text using the original separators, but replacing hyphens with periods to follow standard sign name notation.
}

The default method throws an error for unsupported input types.
}
\value{
  \code{as.sign_name} returns a character vector of class \code{c("sign_name", "character")} with the sign name representation of each input element.

  \code{print.sign_name} displays a character vector of class \code{"sign_name"}.
}
\seealso{
\code{\link{as.cuneiform}} for converting to cuneiform characters,
\code{\link{info}} for retrieving detailed sign information,
\code{\link{split_sumerian}} for splitting Sumerian text into signs
}
\examples{
# Convert transliterated text to sign names
as.sign_name(c("lugal-e", "an-ki"))

# Load transliterated text from a file
file <- system.file("extdata", "transliterated-text.txt", package = "sumer")
x <- readLines(file)
cat(x, sep="\n")

# Convert transliterated text to sign names
as.sign_name(x)

# Using a custom mapping table
path <- system.file("extdata", "etcsl_mapping.txt", package = "sumer")
my_mapping <- read.csv2(path, sep=";", na.strings="")
as.sign_name("lugal", mapping = my_mapping)

}
\keyword{utilities}
\keyword{character}
\keyword{methods}
