% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline.R
\name{pipeline}
\alias{pipeline}
\title{Run a Full Text Classification Pipeline on Preprocessed Text}
\usage{
pipeline(
  vect_method,
  model_name,
  df,
  text_column_name,
  sentiment_column_name,
  n_gram = 1,
  tune = FALSE,
  parallel = FALSE,
  stratify = TRUE
)
}
\arguments{
\item{vect_method}{A string specifying the vectorization method.
Defaults to \code{"bag_of_words"}.
\itemize{
  \item \code{"bag_of_words"} (Alias: \code{"bow"}) - Standard count of words.
  \item \code{"term_frequency"} (Alias: \code{"tf"}) - Normalized counts.
  \item \code{"tfidf"} (Alias: \code{"tf-idf"}) - Term Frequency-Inverse Document Frequency.
  \item \code{"binary"} - Presence/Absence (1/0).
}}

\item{model_name}{A string specifying the model to train.
Defaults to \code{"logistic_regression"}.
\itemize{
  \item \code{"random_forest"} (Alias: \code{"rf"})
  \item \code{"xgboost"} (Alias: \code{"xgb"})
  \item \code{"logistic_regression"} (Alias: \code{"logit"}, \code{"glm"})
}}

\item{df}{The input data frame.}

\item{text_column_name}{The name of the column containing the **preprocessed** text.}

\item{sentiment_column_name}{The name of the column containing the original target labels (e.g., ratings).}

\item{n_gram}{The n-gram size to use for BoW/TF-IDF. Defaults to 1.}

\item{tune}{Logical. If TRUE, the pipeline will perform hyperparameter tuning 
for the selected model. Defaults to FALSE. [NEW]}

\item{parallel}{If TRUE, runs model training in parallel. Default FALSE.}

\item{stratify}{If TRUE, use stratified split by sentiment. Default TRUE.}
}
\value{
A list containing the trained model object, the DFM template,
  class levels, and a comprehensive evaluation report.
}
\description{
This function takes a data frame with pre-cleaned text and handles the
data splitting, vectorization, model training, and evaluation.
}
\examples{
df <- data.frame(
  text = c("good product", "excellent", "loved it", "great quality",
           "bad service", "terrible", "hated it", "awful experience",
           "not good", "very bad", "fantastic", "wonderful"),
  y = c("P", "P", "P", "P", "N", "N", "N", "N", "N", "N", "P", "P")
)


out1 <- pipeline("bow", "logistic_regression", df, "text", "y")
out2 <- pipeline("tfidf", "rf", df, "text", "y") # 'rf' automatically converts to 'random_forest'

}
