% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClustMeanShift.R
\name{mlr_learners_clust.meanshift}
\alias{mlr_learners_clust.meanshift}
\alias{LearnerClustMeanShift}
\title{Mean Shift Clustering Learner}
\description{
Mean shift clustering.
Calls \code{\link[LPCM:ms]{LPCM::ms()}} from package \CRANpkg{LPCM}.

There is no predict method for \code{\link[LPCM:ms]{LPCM::ms()}}, so the method
returns cluster labels for the training data.
}
\section{Dictionary}{

This \link[mlr3:Learner]{mlr3::Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link[mlr3:mlr_learners]{mlr3::mlr_learners} or with the associated sugar function \code{\link[mlr3:mlr_sugar]{mlr3::lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("clust.meanshift")
lrn("clust.meanshift")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{clust}
\item Predict Types: \dQuote{partition}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3cluster}, \CRANpkg{LPCM}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   h \tab untyped \tab - \tab  \tab - \cr
   subset \tab untyped \tab - \tab  \tab - \cr
   thr \tab numeric \tab 0.01 \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   scaled \tab integer \tab 1 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   iter \tab integer \tab 200 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   plot \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(lrn("clust.meanshift")$packages, quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Define the Learner and set parameter values
learner = lrn("clust.meanshift")
print(learner)

# Define a Task
task = tsk("usarrests")

# Train the learner on the task
learner$train(task)

# Print the model
print(learner$model)

# Make predictions for the task
prediction = learner$predict(task)

# Score the predictions
prediction$score(task = task)
\dontshow{\}) # examplesIf}
}
\references{
Cheng, Yizong (1995).
\dQuote{Mean shift, mode seeking, and clustering.}
\emph{IEEE transactions on pattern analysis and machine intelligence}, \bold{17}(8), 790--799.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html#sec-learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Learner]{Learners}: \link[mlr3:mlr_learners]{mlr3::mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[mlr3:Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_clust.MBatchKMeans}},
\code{\link{mlr_learners_clust.SimpleKMeans}},
\code{\link{mlr_learners_clust.agnes}},
\code{\link{mlr_learners_clust.ap}},
\code{\link{mlr_learners_clust.bico}},
\code{\link{mlr_learners_clust.birch}},
\code{\link{mlr_learners_clust.cmeans}},
\code{\link{mlr_learners_clust.cobweb}},
\code{\link{mlr_learners_clust.dbscan}},
\code{\link{mlr_learners_clust.dbscan_fpc}},
\code{\link{mlr_learners_clust.diana}},
\code{\link{mlr_learners_clust.em}},
\code{\link{mlr_learners_clust.fanny}},
\code{\link{mlr_learners_clust.featureless}},
\code{\link{mlr_learners_clust.ff}},
\code{\link{mlr_learners_clust.hclust}},
\code{\link{mlr_learners_clust.hdbscan}},
\code{\link{mlr_learners_clust.kkmeans}},
\code{\link{mlr_learners_clust.kmeans}},
\code{\link{mlr_learners_clust.mclust}},
\code{\link{mlr_learners_clust.optics}},
\code{\link{mlr_learners_clust.pam}},
\code{\link{mlr_learners_clust.protoclust}},
\code{\link{mlr_learners_clust.xmeans}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3cluster:LearnerClust]{mlr3cluster::LearnerClust}} -> \code{LearnerClustMeanShift}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerClustMeanShift-new}{\code{LearnerClustMeanShift$new()}}
\item \href{#method-LearnerClustMeanShift-clone}{\code{LearnerClustMeanShift$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="configure"><a href='../../mlr3/html/Learner.html#method-Learner-configure'><code>mlr3::Learner$configure()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="encapsulate"><a href='../../mlr3/html/Learner.html#method-Learner-encapsulate'><code>mlr3::Learner$encapsulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="selected_features"><a href='../../mlr3/html/Learner.html#method-Learner-selected_features'><code>mlr3::Learner$selected_features()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3cluster" data-topic="LearnerClust" data-id="reset"><a href='../../mlr3cluster/html/LearnerClust.html#method-LearnerClust-reset'><code>mlr3cluster::LearnerClust$reset()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClustMeanShift-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClustMeanShift-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClustMeanShift$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerClustMeanShift-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerClustMeanShift-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerClustMeanShift$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
